package gov.va.med.mhv.health.enums;

public enum ImmunizationEnumeration {
	
	A("A","Adenovirus"),NTHRX("NTHRX","Anthrax"),BCGI("BCGI","BCG"),CV("CV","Chickenpox (Varicella)"),
	
	HLR("HLR","Cholera"),DPT("DPT","DPT (Diphtheria, Tetanus, Pertussis)"),DPHTH("DPHTH","Diphtheria"),
	
	NCPHLT("NCPHLT","Encephalitis (swelling of Brain)"),FLU("FLU","Flu"),ISG("ISG","ISG (Gamma Globulin)"),
	
	HA("HA","Hepatitis A"),HB("HB","Hepatitis B"),HIB("HIB","HIB (Haemophilus Influenza B)"),
	
	LD("LD","Lyme Disease"),MLR("MLR","Malaria"),MMRV("MMR&V","MMR&V (Measles, Mumps, Rubella (German Measles), & Chickenpox (Varcella))"),
	
	MSLS("MSLS","Measles"),MMR("MMR","MMR (Measles, Mumps, Rubella (German Measles))"),MR("MR","Measles + Rubella (German Measles)"),
	
	MNNGC("MNNGC","Meningococcal (Meningitis)A"),MPS("MPS","Mumps"),PLQ("PLQ","Plague"),P("P","Pneumococcal (Pneumonia)"),
	
	POP("POP","Polio"),RBS("RBS","Rabies"),RTVRS("RTVRS","Rotavirus"),RGM("RGM","Rubella (German Measles)"),
	
	RM("RM","Rubella (German Measles) + Mumps"),S("S","Smallpox"),TD("TD","Tetanus + Diphtheria"),TT("TT","Tetanus"),YPHD("YPHD","Typhoid"),YPHS("YPHS","Typhus"),YF("YF","Yellow Fever"),OTHER("OTHER","Other");
	
	private String description;
	private String code;

	ImmunizationEnumeration(String code, String description) {
		this.code=code;
		this.description = description;
	}

	public String getDescription() {
		return description;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public static String getDesc(String code) {
		for (ImmunizationEnumeration e : ImmunizationEnumeration.values()) {
			if (e.getCode().equalsIgnoreCase(code)) {
				return e.getDescription();
			}
		}
		return null;
	}

}
